<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceReview extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "service_reviews";
    protected $fillable = [
        'booked_service_id', 'service_id','customer_id','therapist_id','therapist_community_id','rating','experience','communication','service','is_active','is_featured','is_approved','comment','deleted_at'
    ];

    public function scopeWithAll($query)
    {
        return $query->with('customer')->with('therapist')->with('therapist_community');
    }
    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
    public function therapist()
    {
        return $this->belongsTo(Therapist::class);
    }
    public function therapist_community()
    {
        return $this->belongsTo(TherapistCommunity::class);
    }
    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }


}
